//#define THEMIS 0
#include<bits/stdc++.h>

#ifdef THEMIS
#include "testlib_themis.h"
const std::string TASK_NAME = "INCPATH";
#else
#include "testlib.h"
#endif // THEMIS

using namespace std;
struct Graph{
    vector<vector<int>> e;
    vector<int> mark;
    int markCnt;

    Graph(){}

    Graph(int n){
        e.resize(n);
        mark.resize(n);
        markCnt = 0;
    }

    void add(int x, int y){
        e[x].push_back(y);
    }

    bool reachable(int s, int t){
        if (mark[s] == markCnt) return false;
        mark[s] = markCnt;
        if (s == t) return true;
        for (int y : e[s]){
            if (reachable(y, t)) return true;
        }
        return false;
    }

    bool reachableWithout(int s, int t, int ec){
        mark[ec] = ++markCnt;
        return reachable(s, t);
    }

    vector<int> topoOrder(){
        vector<int> st, in(e.size());
        for (int x = 0; x < e.size(); ++x) for (int y : e[x]){
            ++in[y];
        }
        for (int x = 0; x < e.size(); ++x){
            if (!in[x]) st.push_back(x);
        }
        for (int i = 0; i < st.size(); ++i){
            int x = st[i];
            for (int y : e[x]){
                if (--in[y] == 0) st.push_back(y);
            }
        }
        return st;
    }

};

void check(){
    int n,m, _ans, ansHs;
    n = inf.readInt();
    m = inf.readInt();
    vector<pair<int,int>> E(m);
    for (auto &e : E){
        e.first = inf.readInt() - 1;
        e.second = inf.readInt() - 1;
    }
    Graph G(n), H(n + 1);
    for (auto &e : E) G.add(e.first, e.second);

    for (auto &e : E)
        if (G.reachableWithout(0, e.first, e.second)) H.add(e.first, e.second);
    _ans = ans.readInt();
    ansHs = ouf.readInt();
    if (ansHs==-1) {
        if (_ans == -1)
            quitf(_ok, "In -1 kiếm ít điểm...!\n");
        quitf(_wa, "Không phải -1!\n");
    }
    vector<int> val(n+2, ansHs);
    for (int i = 2; i <= n; ++i)
        val[i] = ouf.readInt();

    vector<int> mark(n+2);
    for (int i = 1; i <= n; ++i)
        if (val[i] > n || val[i] < 1 || mark[val[i]]++)
            quitf(_wa, "Không phải hoán vị!\n");

    for (int x = 1; x <= n; ++x)
        for (int y = 1; y <= n; ++y)
            if (val[x] > val[y])
                if (H.reachableWithout(x-1, y-1, n))
                    quitf(_wa, "Không thỏa mãn!\n");
    if (_ans == -1)
        quitf(_ok, "Ơ mây zing, gút chóp em, em đúng là thiên tài!\n");
    else
        quitf(_ok, "Ơ mây zing, gút chóp em, may cho em là test yếu!\n");
}

int main(int argc,char *argv[]){
#ifdef THEMIS
    registerTestlibThemis(TASK_NAME + ".inp", TASK_NAME + ".out");
#else
    registerTestlibCmd(argc, argv);
#endif
    check();
    return 0;
}
