//#include "testlib_themis.h"
#include "testlib.h"
#include<bits/stdc++.h>
#define FOR(i, a, b) for (int i = (a), _b = (b); i <= _b; i++)
#define FORD(i, b, a) for (int i = (b), _a = (a); i >= _a; i--)
#define REP(i, n) for (int i = 0, _n = (n); i < _n; i++)
#define FORE(i, v) for (__typeof((v).begin()) it = (v).begin(); i != (v).end(); i++)
#define ALL(v) (v).begin(), (v).end()
#define IS_INF(x)   (std::isinf(x))
#define IS_NAN(x)   (std::isnan(x))
#define fi   first
#define se   second
#define MASK(i) (1LL << (i))
#define BIT(x, i) (((x) >> (i)) & 1)
#define div   ___div
#define next   ___next
#define prev   ___prev
#define left   ___left
#define right   ___right
#define __builtin_popcount __builtin_popcountll
using namespace std;
template<class X, class Y>
    bool minimize(X &x, const Y &y) {
        X eps = 1e-9;
        if (x > y + eps) {
            x = y;
            return true;
        } else return false;
    }
template<class X, class Y>
    bool maximize(X &x, const Y &y) {
        X eps = 1e-9;
        if (x + eps < y) {
            x = y;
            return true;
        } else return false;
    }
template<class T>
    T Abs(const T &x) {
        return (x < 0 ? -x : x);
    }

/* Author: Van Hanh Pham */

/** END OF TEMPLATE - ACTUAL SOLUTION COMES HERE **/

const double POINT_VALID_PERMUTATION = 0.17;
const double POINT_SATISFY_SMALL_QUERIES = 0.46;
const double POINT_SATISFY_ALL_QUERIES = 0.77;

#define VALID_PERMUTATION   1
#define SATISFY_SMALL_QUERIES   2
#define SATISFY_ALL_QUERIES   3
#define CORRECT   4

int getNumber(const string &s) {
    int res = 0;
    FORE(it, s) {
        if (*it < '0' || *it > '9') return -1;
        res = res * 10 + *it - '0';
    }
    return res;
}

#define INFO_MAX   1
#define INFO_MIN   2
#define INFO_CMP   3

struct Info {
    int type, x, y;

    Info() {
        type = x = y = 0;
    }

    Info(InStream &stream) {
        string input = stream.readWord();
        if (getNumber(input) > 0) {
            type = INFO_CMP;
            x = getNumber(input);
            input = stream.readWord();
            y = stream.readInt();
            if (input == ">") swap(x, y);
        } else {
            type = input == "MAX" ? INFO_MAX : INFO_MIN;
            x = stream.readInt();
            y = stream.readInt();
        }
    }

    bool _small(void) const;
    bool check(void) const;

    string details(void) const {
        if (type == INFO_CMP) return format("%d < %d", x, y);
        else return format("%s %d %d", type == INFO_MAX ? "MAX" : "MIN", x, y);
    }
};

#define MAX   300300
int numItem, numGroup, numInfo;
int outPerm[MAX], ansPerm[MAX];
int value[MAX], minValue[MAX], maxValue[MAX];
pair<int, int> groups[MAX];
Info infos[MAX];

void init(void) {
    numItem = inf.readInt();
    numGroup = inf.readInt();
    numInfo = inf.readInt();
    FOR(i, numItem + 1, numItem + numGroup) {
        groups[i].fi = inf.readInt();
        groups[i].se = inf.readInt();
    }
    FOR(i, 1, numInfo) infos[i] = Info(inf);
}

bool Info::_small(void) const {
    return type == INFO_CMP && x <= numItem && y <= numItem;
}
bool Info::check(void) const {
    if (type == INFO_MAX) return maxValue[x] == value[y];
    if (type == INFO_MIN) return minValue[x] == value[y];
    return maxValue[x] <= minValue[y];
}

int readAnswer(InStream &stream, int perm[]) {
    FOR(i, 1, numItem) perm[i] = stream.readInt(1, numItem);
    memset(value, 0, sizeof value);
    FOR(i, 1, numItem) {
        if (value[perm[i]] > 0) {
            int j = value[perm[i]];
            stream.quitf(_wa, "perm[%d] = perm[%d] = %d", i, j, perm[i]);
        } else value[perm[i]] = i;
    }

    FOR(i, 1, numItem) minValue[i] = maxValue[i] = value[i];
    FOR(i, numItem + 1, numItem + numGroup) {
        int x = groups[i].fi, y = groups[i].se;
        minValue[i] = min(minValue[x], minValue[y]);
        maxValue[i] = max(maxValue[x], maxValue[y]);
    }

    bool violateSmall = false;
    bool violate = false;

    FOR(i, 1, numInfo) if (!infos[i].check()) {
        if (&stream == &ans) quitf(_fail, "Condition failed: %s", infos[i].details().c_str());
        violate = true;
        if (infos[i]._small()) violateSmall = true;
    }

    if (!violate) return SATISFY_ALL_QUERIES;
    if (!violateSmall) return SATISFY_SMALL_QUERIES;
    return VALID_PERMUTATION;
}

bool checkLexicography(void) {
    FOR(i, 1, numItem) if (outPerm[i] != ansPerm[i]) return outPerm[i] < ansPerm[i];
    return true;
}

void process(void) {
    int cont = readAnswer(ouf, outPerm);
    int jury = readAnswer(ans, ansPerm);

    if (jury != SATISFY_ALL_QUERIES) {
        quitf(_fail, "Jury's answer does not satisfy all given information.");
    }

    if (cont == VALID_PERMUTATION) {
        quitp(VALID_PERMUTATION, "Contestant's answer is a valid permutation.");
    }

    if (cont == SATISFY_SMALL_QUERIES) {
        quitp(SATISFY_SMALL_QUERIES, "Contestant's answer satisfies small information.");
    }

    if (checkLexicography()) {
        quitf(_ok, "Contestant's answer is optimal.");
    } else {
        quitp(SATISFY_ALL_QUERIES, "Contestant's answer satisfies all information.");
    }
}

const string TASK_NAME = "SBBCFFFFS";
int main(int argc, char* argv[]) {
    #ifdef THEMIS
    registerTestlibThemis(TASK_NAME + ".inp", TASK_NAME + ".out");
    #else
    registerTestlibCmd(argc, argv);
    #endif // THEMIS

    init();
    process();
    return 0;
}

/*** LOOK AT MY CODE. MY CODE IS AMAZING :D ***/
