#include "testlib.h"
#include<bits/stdc++.h>
#define nmax 201
using namespace std;
typedef vector<int> vti;
typedef vector<vti> vtv;
class dset {
private:
    int n;
    vti par;
public:
    dset():n(nmax), par(vti(nmax, -1)) {}
    dset(int n): n(n), par(vti(n + 1, -1)) {}
    int root(int u) {
        if (par[u] < 0) return u;
        return(par[u] = root(par[u]));
    }
    bool conn(int u, int v) {
        return root(u) == root(v);
    }
    void uni(int u, int v) {
        int ru = root(u), rv = root(v);
        if (ru == rv) return;
        if (par[ru] < par[rv]) swap(ru, rv);
        par[rv] += par[ru];
        par[ru] = rv;
    }
};
vtv a, d;
void floyd(int n) {
    for (int k = 1; k <= n; k++)
        for (int i = 1; i <= n; i++)
            for (int j = 1; j <= n; j++)
                if (d[i][k] && d[k][j] && (!d[i][j] || (d[i][k] + d[k][j]) < d[i][j]))
                    d[i][j] = d[j][i] = d[i][k] + d[k][j];
}

int main(int argc, char **args) {
    registerTestlibCmd(argc, args);

    int n, m, u, v, w, res, _ans;
    n = inf.readInt();
    m = inf.readInt();
    a = vtv(n + 1, vti(n + 1, 0));
    d = vtv(a);
    while (m--) {
        u = inf.readInt();
        v = inf.readInt();
        w = inf.readInt();
        a[u][v] = a[v][u] = w;
    }
    u = ans.readInt();
    res = ans.readInt();

    w = ouf.readInt(1, n);
    _ans = ouf.readInt();
    if (_ans != res)
        quitf(_wa, "Phuong an chua toi uu!\n");

    dset ds(n);
    while (!ouf.seekEof()) {
        u = ouf.readInt(1, n);
        v = ouf.readInt(1, n);
        if (!a[u][v] || d[u][v])
            quitf(_wa, "Duong (%d, %d) khong hop ly!\n", u, v);
        d[u][v] = d[v][u] = a[u][v];
        if (ds.conn(w, u) && ds.conn(w, v))
            quitf(_wa, "Duong (%d, %d) khong hop ly!\n", u, v);
        ds.uni(u, v);
    }
    floyd(n);
    _ans = 0;
    for (u = 1; u <= n; u++) {
        if (u == w) continue;
        if (!d[w][u])
            quitf(_wa, "Dinh %d chua thong voi dinh %d!\n", u, w);
        _ans = max(_ans, d[w][u]);
    }
    if(_ans != res)
        quitf(_wa, "Phuong an chua toi uu!\n");

    quitf(_ok, "Phuong an dduoc chap nhan!\n");
    return 0;
}
