#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
bool check(istream &in, istream &ans, istream &out, feedback_function waf) {
    int nTest;
    in >> nTest;
    double score = 1;
    for(int iTest = 1; iTest <= nTest; iTest++) {
        long long n, item;
        int corectResult, contestantResult;
        in >> n;
        ans >> corectResult;
        for(int i = 0; i < corectResult; i++) ans >> item;
        if (!(out >> contestantResult))
            waf("Du lieu ra khong dung dinh dang!!!\n");

        if (corectResult != contestantResult)
            waf("Ket qua test %d so dong xu khong dung!!!", iTest);

        vector <long long> coints;
        for(int i = 0; i < contestantResult; i++)
        {
            if (!(out >> item))
                waf("Du lieu ra khong dung dinh dang!!!\n");
            coints.push_back(item);
        }

        sort(coints.begin(), coints.end());
        long long cur = 0;
        for(long long item : coints)
        {
            if (item > cur + 1)
                waf("Truy vet test %d khong dung!!!", iTest);
            cur += item;
        }
        if (cur < n)
            waf("Truy vet test %d khong dung!!!", iTest);
    }
    string t;
    if (out >> t) {
        waf("Du lieu ra khong dung dinh dang!!!\n");
    }
    judge_message("OK correct!!!");
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
