#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 5001

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}
typedef vector<int> vti;
class dset {
private:
    int n;
    vti par;
public:
    dset():n(nmax), par(vti(nmax, -1)) {}
    dset(int n): n(n), par(vti(n + 1, -1)) {}
    int root(int u) {
        if (par[u] < 0) return u;
        return(par[u] = root(par[u]));
    }
    bool conn(int u, int v) {
        return root(u) == root(v);
    }
    void uni(int u, int v) {
        int ru = root(u), rv = root(v);
        if (ru == rv) return;
        if (par[ru] < par[rv]) swap(ru, rv);
        par[rv] += par[ru];
        par[ru] = rv;
    }
    int cnt(int u) {
        return -par[root(u)];
    }
};

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int n, m, os, res, u, v;
    inf >> n >> m;
    dset ds(n);
    while (m--) {
        inf >> u >> v;
        ds.uni(u, v);
    }
    ans >> res;
    if (!(ouf >> os))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    if (res != os)
        waf("Sai. So duong truyen can them khong dung!\n");
    if (os > 0) {
        for (int i = 0; i < os; i++) {
            if (!(ouf >> u >> v))
                waf("Sai. Du lieu ra khong dung dinh dang!\n");
            if (u < 1 || u > n || v < 1 || v > n)
                waf("Sai. Du lieu ra khong dung!\n");
            if (ds.conn(u, v))
                waf("Sai. Them cung khong dung!\n");
            ds.uni(u, v);
        }
    }
    if (ds.cnt(1) != n)
        waf("Sai. Mang chua lien thong!\n");
    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
