#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}
using namespace std;
typedef vector<int> vti;
typedef vector<vti> vtv;
vtv a;
int n, dest, res;
/*
    East (Đông):    →
    West (Tây):     ←
    Southern (Nam): ↓
    North   (Bắc)   ↑
*/
#define dE 1
#define dW 2
#define dS 3
#define dN 4
int changedir(int dir, int barrie) {
    if (!barrie) return dir;
    switch (dir) {
    case dE:
        return (barrie == 1 ? dN : dS);
    case dW:
        return (barrie == 1 ? dS : dN);
    case dS:
        return (barrie == 1 ? dE : dW);
    case dN:
        return (barrie == 1 ? dW : dE);
    }
}
int shoot(int r) {
    int dx[5] = {0 , 1, -1, 0, 0};
    int dy[5] = {0 , 0, 0, 1, -1};
    int y = r, x = 0, dir = dE;
    do {
        x += dx[dir];
        y += dy[dir];
        if (y <= 0 || y > n || x <= 0) return 0;
        if (x > n) return y;
        dir = changedir(dir, a[y][x]);
        if (a[y][x])
            a[y][x] = 3 - a[y][x];
    } while (1);
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int u, as;

    ans >> res;

    if (!(ouf >> as))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    if (res < as || (as == 0 && res > 0))
        waf("Sai. So luot ban khong dung!\n");
    if (as > 0) {
        inf >> n;
        a = vtv(n + 1, vti(n + 1, 0));
        for (int i = 1; i <= n; i++)
            for (int j = 1; j <= n; j++)
                inf >> a[i][j];
        inf >> dest;
        int r = 0;
        for (int i = 0; i < as; i++) {
            if (!(ouf >> u))
                waf("Sai. Du lieu ra khong dung dinh dang!\n");
            if (u < 1 || u > n)
                waf("Sai. Ban o ngoai bang!\n");
            r = shoot(u);
        }
        if (r != dest)
            waf("Sai. Ban chua trung muc tieu!\n");
    }

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
