#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}
#define nmax 1001
typedef vector<int> vti;
typedef vector<vti> vtv;
typedef pair<int, int> pii;
typedef vector<pii> vtp;
vtv a;
vtp p;
int m, n, sx, sy, tx, ty, res;
/*
    East (Đông):    →
    West (Tây):     ←
    Southern (Nam): ↓
    North   (Bắc)   ↑
*/
#define dE 1
#define dW 2
#define dS 3
#define dN 4
int direction(pii a, pii b) {
    if (a.first == b.first) {
        if (abs(a.second - b.second) != 1)
            return 0;
        return (b.second > a.second ? dE : dW);
    }
    if(a.second != b.second || abs(a.first - b.first) != 1)
        return 0;
    return (b.first > a.first ? dS : dN);
}
bool check() {
    if(p[0].first != sy || p[0].second != sx)
        return 0;
    if (p[res].first != ty || p[res].second != tx)
        return 0;
    int dir = 0, newdir;
    for (int i = 1; i <= res; i++) {
        newdir = direction(p[i - 1], p[i]);
        if (newdir == 0)
            return 0;
        if(dir == newdir)
            return 0;
        dir = newdir;
    }
    return 1;
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int u, v;
    inf >> m >> n >> sy >> sx >> ty >> tx;
    a = vtv(m + 1, vti(n + 1, 0));
    while (inf >> u >> v)
        a[u][v] = 1;

    string s, s1;
    ans >> s;
    if (!(ouf >> s1))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    if (s != s1)
        waf("Sai. Ket qua khong dung!\n");
    if (s != "NO") {
        res = stoi(s);
        for (int i = 0; i <= res; i++) {
            if (!(ouf >> u >> v))
                waf("Sai. Du lieu ra khong dung dinh dang!\n");
            if (u < 0 || u > m || v < 0 || v > n)
                waf("Sai. Toa do o di qua khong dung (%d, %d)!\n", u, v);
            if (a[u][v])
                waf("Sai. Di vao o cam (%d, %d)!\n", u, v);
            p.push_back(pii(u, v));
        }
        if (!check())
            waf("Sai. Duong di khong thoa man!\n");
    }
    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
