#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 5001
typedef struct edge {
    int u, v, t;
    edge(): u(0), v(0), t(0) {}
    edge(int u, int v, int t): u(u), v(v), t(t) {}
} edge;

typedef vector<edge> vte;
typedef vector<int> vti;
class dset {
private:
    int n;
    vti par;
public:
    dset():n(nmax - 1), par(vti(nmax, -1)) {}
    dset(int n): n(n), par(vti(n + 1, -1)) {}
    dset(const dset &ds):n (ds.n), par(ds.par) {}
    dset operator =(const dset &ds) {
        (*this).n = ds.n;
        (*this).par.assign(ds.par.begin(), ds.par.end());
        return *this;
    }
    int root(int u) {
        if (par[u] < 0) return u;
        return(par[u] = root(par[u]));
    }
    bool conn(int u, int v) {
        return root(u) == root(v);
    }
    bool conn() {
        for (int i = 2; i <= n; i++)
            if (!conn(1, i)) return false;
        return true;
    }
    void uni(int u, int v) {
        int ru = root(u), rv = root(v);
        if (ru == rv) return;
        if (par[ru] < par[rv]) swap(ru, rv);
        par[rv] += par[ru];
        par[ru] = rv;
    }
};
int check(dset &ds, vte e, int code) {
    int cnt = 0;
    for (int i = 0; i < e.size(); i++) {
        if (e[i].t != code) continue;
        int u = e[i].u, v = e[i].v;
        if (ds.conn(u, v)) cnt++;
        else ds.uni(u, v);
    }
    return cnt;
}
bool check(int n, int ans, vte e, vti r) {
    dset d3(n);
    int n3 = check(d3, e, 3);
    dset d1(d3), d2(d3);
    int n1 = check(d1, e, 1), n2 = check(d2, e, 2);
    int nremove = (d1.conn() && d2.conn()) ? n1 + n2 + n3 : -1;
    if (nremove != ans)
        return 0;

    if (ans > 0) {
        for (int i = 0; i < r.size(); i++)
            e[r[i] - 1].t = 0;
        d3 = dset(n);
        if (check(d3, e, 3) != 0)
            return 0;
        d1 = d3; d2 = d3;
        if (check(d1, e, 1) != 0)
            return 0;
        if (check(d2, e, 2) != 0)
            return 0;
        return (d1.conn() && d2.conn());
    }
    return 1;
}
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int n, m, as;
    vti r;
    inf >> n >> m;
    if (!(ouf >> as))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    for (int i = 0, x; i < as; i++) {
        if (!(ouf >> x))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (x < 0 || x > m)
            waf("Sai. Khong co canh chi so %d!\n", x);
        r.push_back(x);
    }
    vte e(m);
    for (int i = 0; i < m; i++)
        inf >> e[i].u >> e[i].v >> e[i].t;
    if (!check(n, as, e, r))
        waf("Sai. Phuong an loai bo khong dung!\n");

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
