#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}


typedef vector<int> vti;
typedef pair<int, int> pii;
typedef vector<pii> vtp;
vti acuts, ocuts;
vtp abridges, obridges;

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int ac, ab, oc, ob;
    ans >> ac >> ab;
    if (!(ouf >> oc >> ob))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    if (ac != oc || ab != ob)
        waf("Sai. So luong khop va cau khong dung!\n");
    for (int i = 0, u; i < oc; i++) {
        if (!(ouf >> u))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        ocuts.push_back(u);
    }
    for (int i = 0, u, v; i < ob; i++) {
        if (!(ouf >> u >> v))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (v < u)
            swap(u, v);
        obridges.push_back({u, v});
    }
    sort(ocuts.begin(), ocuts.end());
    sort(obridges.begin(), obridges.end(), [](pii x, pii y) {
            return x.first < y.first || (x.first == y.first && x.second < y.second);
         });

    for (int i = 0, u; i < ac; i++) {
        ans >> u;
        acuts.push_back(u);
    }
    for (int i = 0, u, v; i < ab; i++) {
        ans >> u >> v;
        if (v < u)
            swap(u, v);
        abridges.push_back({u, v});
    }
    sort(acuts.begin(), acuts.end());
    sort(abridges.begin(), abridges.end(), [](pii x, pii y) {
            return x.first < y.first || (x.first == y.first && x.second < y.second);
         });

    for (int i = 0; i < ac; i++)
        if (acuts[i] != ocuts[i])
            waf("Sai. Danh sach khop sai (%d)!\n", ocuts[i]);
    for (int i = 0; i < ab; i++)
        if (abridges[i].first != obridges[i].first || abridges[i].second != obridges[i].second)
            waf("Sai. Danh sach cau sai!\n", ocuts[i]);

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
