#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 201

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    bool a[nmax][nmax];
    bool visited[nmax][nmax];
    int m, n, sr, sc, prer = -1, prec, r, c;
    string as, os, s;
    ans >> as;
    if (!(ouf >> os))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (as != os) {
        if (as == "NO")
            waf("Sai. Khong co duong di thoa man!\n");
        else
            waf("Sai. Co duong di thoa man!\n");
    }
    if (as == "NO") {
        OK(ouf, waf);
        return 1;
    }

    inf >> m >> n;
    memset(a, 0, sizeof a);
    for (int i = 1; i <= m; i++) {
        inf >> s;
        for (int j = 0; j < n; j++)
            if (s[j] == 'E')
                sr = i, sc = j + 1;
            else if (s[j] == 'X')
                a[i][j + 1] = 1;
    }

    memset(visited, 0, sizeof visited);

    while (ouf >> r >> c) {
        if (r < 1 || r > m || c < 1 || c > n)
            waf("Sai. O (%d, %d) khong nam trong me cung!\n", r, c);

        if (prer == -1) {
            if (r != sr || c != sc)
                waf("Sai. Duong di khong xuat phat tu o (%d, %d)!\n", sr, sc);
            prer = r; prec = c;
            visited[r][c] = 1;
        } else {
            if (abs(r - prer) + abs(c - prec) != 1)
                waf("Sai. Buoc di khong dung (%d, %d)->(%d, %d)!\n", prer, prec, r, c);

            if (a[r][c])
                waf("Sai. Di vao o nguy hiem (%d, %d)!\n", r, c);

            if (visited[r][c])
                waf("Sai. O (%d, %d) da tham!\n", r, c);

            visited[r][c] = 1;
            prer = r; prec = c;
        }
    }
    if (r != 1 && r != m && c != 1 && c != n)
        waf("Sai. Duong di khong ra bien!\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
