from functools import wraps
import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
a_K = int(ans.readline().strip())
ouf = open("user_out", "r")
o_K = int(ouf.readline().strip())

if a_K == o_K:
	ok(u"Ơ mây zing, gút chóp em, làm tốt lắm")
else:
	msg(50.0, "Ơ mây zing, gút chóp em, kính biếu em ít điểm về ăn tết.")