#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;

const int nmax = 301;
const int kmax = 31;
int x[nmax], w[kmax], cnt = 0, idx = 0;
int n, k, kq, ans, v;
bool check(int v)
{
	do {
		idx++;
		if (idx > n || x[idx] > v)
			return false;
		if (v == x[idx])
		{
			if (cnt >= k)
				return false;
			w[++cnt] = v;
			return true;
		}
	} while (true);
}
int cost()
{
	int i, j = 1, r = 0;
	for (i = 1; i <= n; i++)
		if (x[i] <= w[j])
			r += abs(w[j] - x[i]);
		else
		{
			if (j < k && x[i] - w[j] > w[j + 1] - x[i])
				j++;
			r += abs(x[i] - w[j]);
		}
	return r;
}

void check(istream &fin, istream &fans, istream &fout, feedback_function waf) {
    fin >> n >> k;
	for (int i = 1; i <= n; i++)
		fin >> x[i];
    fans >> kq;

	if (!(fout >> ans))
        waf("Du lieu ra khong dung dinh dang!\n");

	if (ans != kq)
        waf("Tong duong ong su dung khong dung!\n");

	while (fout >> v)
		if (!check(v)) {
            judge_message("Phuong an lap dat khong dung!\n");
            accept_with_score(50.);
		}

	if (cost() != kq) {
        judge_message("Phuong an lap dat khong dung!\n");
        accept_with_score(50.);
	}
    judge_message("OK. Phuong an lap dat hop ly. Tong do dai duong ong su dung la %d\n", kq);
    accept();
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
}
