#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 21
typedef long long ll;
ll t[nmax];
bool used[nmax];
bool check(ll o, int n) {
    for (int i = 1; i <= n; i++)
        if (t[i] == o && !used[i]) {
            used[i] = 1;
            return 1;
        }
    return 0;
}
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    ll M, MM = 0;
    int n, a, o;
    ans >> a;
    if (a == -1) {
        if (!(ouf >> o))
            waf("Du lieu ra khong dung dinh dang.\n");
        if (o != -1)
            waf("Sai. Khong the tra dung so tien.\n");
        judge_message("OK. Khong co phuong an tra tien!\n");
        return 1;
    }
    memset(used, 0, sizeof used);
    inf >> n >> M;
    for (int i = 1; i <= n; i++)
        inf >> t[i];
    while (ouf >> o) {
        if (!check(o, n))
            waf("Sai. Khong con to menh gia %lld de tra.\n", o);
        MM += o;
    }
    if (MM != M)
        waf("Sai. Tong so tien da tra la %lld dong, khong phai %lld dong.\n", MM, M);

    judge_message("OK. Tong so tien tra dung %lld dong!\n", M);
        return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
