#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Phuong an hai qua toi uu!\n");
}

#define ld long double
#define ll long long

const int maxn = (1<<20);
int n;
int a[maxn+1];
int l[maxn*5],r[maxn*5],vt[maxn+1];
ll sum[maxn*5];
int res,Res;

bool ok;

set<int> used;
void initIT(int i,int x,int y)
{
	l[i] = x;
	r[i] = y;
	if (x==y)
	{
		sum[i] = a[x];
		vt[x] = i;
	}
	else
	{
		int m = (x+y)>>1;
		initIT(i<<1,x,m);
		initIT((i<<1)|1,m+1,y);
		sum[i] = sum[i<<1] + sum[(i<<1)|1];
	}
}

void update(int i)
{
	if (i<1) return;
	sum[i] = sum[i<<1]+sum[(i<<1)|1];
	if (abs(sum[i<<1]-sum[(i<<1)|1])>1)
	{
		//cout << i << ' ' << l[i] << ' ' << r[i] << ' ' << sum[i<<1] << ' ' << sum[(i<<1)|1] << '\n';
		ok = false;
	}
	update(i>>1);
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    inf >> n;
	for (ll i=1; i<=(1<<n); i++)
		inf >> a[i];

	initIT(1,1,(1<<n));
	ok = true;

	if (!(ouf >> res))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

	ans >> Res;

	if (Res!=res)
        waf("Sai. So qua hai duoc chua toi uu!\n");

	used.clear();
	for (ll i=1; i<=res; i++)
	{
		int x;
		if (!(ouf >> x)) {
            judge_message("Khong hai du %d qua!\n", res);
            accept_with_score(25.);
		}

		if (x<1 || x>(1<<n))
		{
            judge_message("So thu tu qua khong hop le!\n");
            accept_with_score(25.);
		}

		if (used.count(x))
		{
		    judge_message("Qua %d bi hai hai lan!\n", x);
			accept_with_score(25.);
		}

		used.insert(x);
		sum[vt[x]] = 0;
		update(vt[x]>>1);
	}

	if (!ok)
	{
		judge_message("Sai thu tu hai!\n");
		accept_with_score(25.);
	}

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
