#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Phuong an dao dong duoc chap nhan!\n");
}

#define nmax 1005
int n, m, a[nmax][nmax];
vector<int> rowID;

bool Check() {
    for(int j = 0; j < m; ++j) {
        set<int> s;
        for(int i = 0; i < n; ++i)
            s.insert(a[i][j]);
        if (s.size() < n)
            return false;
    }
    return true;
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    string ansJury, ansContestant;

    ans >> ansJury;
    if (!(ouf >> ansContestant))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (ansContestant == "Yes") {
        int k, x;
        if (!(ouf >> k))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");

        if (k > 3000)
            waf("Contestant used more than 3000 row flip operations.");

        inf >> n >> m;
        for (int i = 0; i < n; i++)
            for (int j = 0; j < m; j++)
                inf >> a[i][j];

        for(int i = 0; i < k; ++i) {
            if (!(ouf >> x))
                waf("Sai. Du lieu ra khong dung dinh dang!\n");
            if (x < 1 || x > n)
                waf("Invalid row index.");
            --x;
            reverse(a[x], a[x] + m);
        }

        if (Check()) {
            if (ansJury == "Yes") {
                OK(ouf, waf);
                return 1;
            }
            else {
                judge_message("Correct answer (even when jury's solution did not find an answer).");
                return 1;
            }
        } else
            waf("Incorrect answer, an element appeared more than once in a column.");

    } else if (ansContestant == "No") {
        if (ansJury == "Yes")
            waf("Incorrect answer, jury's solution found an answer when contestant's solution did not.");
    } else {
        waf("Incorrect answer, received a string different from 'Yes' and 'No'.");
    }

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
