#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
const int N = 1003;
int n, b[N], d[N];
char a[N], c[N];

bool movable(int x, int y, int u, int v) {
    return abs(x-u) == abs(y-v);
}

bool ok(int p1, int p2, int q1, int q2, istream &fout) {
    if ((p1+p2+q1+q2)&1) {
        string s; if (!(fout >> s))
            return 0;
        return s=="Impossible";
    }
    int m;
    if (!(fout >> m))
        return 0;
    if (m>4) return false;
    char w; int w1, w2;
    if (!(fout >> w >> w2))
        return 0;
    w1 = w - 64;
    if (w1!=p1 || w2!=p2) return false;

    for (int i=1; i<=m; i++) {
        int r1 = w1, r2 = w2;
        if (!(fout >> w >> w2))
            return 0;
        w1 = w - 64;
        if (w1<1 || w1>8 || w2<1 || w2>8) return false;
        if (w1==r1 || w2==r2) return false;
        if (!movable(r1, r2, w1, w2)) return false;
    }
    if (w1!=q1 || w2!=q2) return false;
    return true;
}

bool ok(istream &fout) {
    for (int i=1; i<=n; i++) {
        if (!ok(a[i]-64, b[i], c[i]-64, d[i], fout))
        return false;
    }
    return true;
}
void check(istream &fin, istream &fans, istream &fout, feedback_function waf) {
    fin >> n;
    for (int i=1; i<=n; i++)
        fin >> a[i] >> b[i] >> c[i] >> d[i];
    if (!ok(fans)) waf("Jury's answer is not correct!");
    if (!ok(fout))
        waf("Wrong answer!");
    judge_message("Correct!\n");
    accept();
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
}
