from functools import wraps
import sys
import codecs

vis = [0] * 201
A = [[0 for i in range(201)] for _ in range(201)]
B = [0] * 201

def DFS(u, n, target):
    vis[u] = 1
    if u == target:
        return True
    for v in range(1, n + 1):
        if vis[v] == 0 and B[v] == 0 and A[u][v] == 1:
            if DFS(v, n, target):
                return True
    return False

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

inf = open("input", 'r')
n, m = [int(x) for x in inf.readline().strip().split()]
a, b = [int(x) for x in inf.readline().strip().split()]
c = [0]

for i in range(1, n + 1):
    c.append(int(inf.readline().strip()))

for _ in range(m):
    u, v = [int(x) for x in inf.readline().strip().split()]
    A[u][v] = 1
    A[v][u] = 1

ans = open('answer', 'r')
ai = [int(x) for x in ans.readline().strip().split()]
afee = 0
for x in ai:
    afee += c[x]

ouf = open("user_out", "r")
oi = [int(x) for x in ouf.readline().strip().split()]
ofee = 0

for x in oi:
    ofee += c[x]
    B[x] = 1

if ofee > afee:
    wrong(f"Chi phí chưa tối ưu. Đáp án {afee}, Bạn: {ofee}")

if DFS(a, n, b):
    wrong(f"Với những chốt đã chặn, vẫn có thể đi từ {a} tới {b}")

ok(u"Ơ mây zing, gút chóp em")