#include <vector>
#include <iostream>
#include <fstream>
#include <algorithm>

using namespace std;

#define quitf(score, FMT...) { fprintf(stderr, FMT); fp << score << endl; exit(0); }
#define _wa 0

ofstream fp;

int c, s, k;
std::vector<std::vector<int>> d;

std::vector<std::vector<int>> x; //x[day][company] = location

namespace Checker {

void check(long long answer) {

    // Calculate actual cost
    long long calculated = 0;
    for (int i = 0; i < k; i++) {
        sort(x[i].begin(), x[i].end());
        for (int j = 0; j < c; j++) {
            calculated += abs(x[i][j] - x[i][c/2]);
        }
    }

    if (calculated != answer) {
        quitf(_wa, "Contestant returned %lld but the tickets gives a total value of %lld", answer, calculated);
    }
}

}

ifstream fin, fans;

const std::string output_secret = "131b432f-1f84-4f8f-9d55-41e868a6bc5d";

int main() {
  ios::sync_with_stdio(false);

  fin.open("input");
  fans.open("answer");
  fp.open("score.txt");

  string secret; fin >> secret; cout << secret << endl;
  fin >> c >> s >> k;
  cout << c << ' ' << s << ' ' << k << endl;
  d.resize(c);
  for (int i = 0; i < c; ++i) {
    d[i].resize(s);
    for (int j = 0; j < s; ++j) {
      fin >> d[i][j];
      cout << d[i][j] << ' ';
    }
    cout << endl;
  }

  string result;
  getline(cin, result);
  if (result != output_secret) {
    cerr << "secret mismatch" << endl;
    fp << 0 << endl;
    return 0;
  }
  getline(cin, result);
  if (result != "OK") {
    cerr << result << endl;
    fp << 0 << endl;
    return 0;
  }

  long long jans, pans;
  cin >> pans;
  fans >> result; fans >> result;
  fans >> jans;
  if (pans == jans) {
    // Validate output file rows
    x.resize(k);
    for (int i = 0; i < c; i++) {
        for (int j = 0; j < s; j++) {
            int day;
            cin >> day;
            if (0 <= day && day < k) {
                // Ship i,j was sent on day loc
                x[day].push_back(d[i][j]);
            } else if (day != -1) {
                quitf(_wa, "Ticket %d of color %d is played on invalid day %d", i, j, day);
            }
        }
        // All days should now have i+1 boats
        for (int j = 0; j < k; j++) {
            if ((int)x[j].size() < i + 1) {
                quitf(_wa, "There is no ticket of color %d on day %d", i, j);
            } else if ((int)x[j].size() > i + 1) {
                quitf(_wa, "There is multiple tickets of color %d on day %d", i, j);
            }
        }
    }

    Checker::check(pans);

    cerr << "OK answer is " << pans << ", participant allocated the tickets correctly" << endl;
    fp << 100 << endl;
  } else {
    cerr << "wrong answer expected " << jans << " found " << pans << endl;
    fp << 0 << endl;
  }

  return 0;
}
