#include <vector>
#include <iostream>
#include <fstream>

using namespace std;

#define quitf(score, FMT...) { fprintf(stderr, FMT); fp << score << endl; exit(0); }

ifstream fin, fans;
ofstream fp;

int n;
std::vector<std::vector<int>> p, b, b_adj;

namespace Checker {

const int MAXP = 3;
const int MAXB = 1;

vector<vector<int>> actual_ways;
vector<int> visited;

void too_many(int src, int dst) {
    quitf(
        0,
        "Too many ways to get from %d to %d, should be %d found no less than %d",
        src, 
        dst, 
        p[src][dst], 
        actual_ways[src][dst]
    );
}

void dfs(int src, int x) {
    visited[x] = 1;
    // printf("in %d / ", x);
    actual_ways[src][x] += 1;
    if (actual_ways[src][x] > p[src][x]) {
        too_many(src, x);
    }
    for (int i = 0; i < (int) b_adj[x].size(); i++) {
        if (!visited[b_adj[x][i]]) {
            dfs(src, b_adj[x][i]);
        }
    }
    // printf("out %d / ", x);
    visited[x] = 0;
}

void check() {

    // Check that b is symmetric
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (b[i][j] != b[j][i]) {
                quitf(0, "b is not symmetric: b[%d][%d] (%d) != b[%d][%d] (%d)", i, j, b[i][j], j, i, b[j][i]);
            }
        }
    }
    
    // Check that b diagonal is 0
    for (int i = 0; i < n; i++) {
		if (b[i][i] != 0) {
			quitf(0, "b[%d][%d] is not 0", i, i);
		}
	}

    // Populate actual_ways
    actual_ways.resize(n);
    for (int i = 0; i < n; i++) {
        actual_ways[i].resize(n, 0);
    }
    visited.resize(n, 0);

    for (int i = 0; i < n; i++) {
        dfs(i, i);
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (p[i][j] != actual_ways[i][j]) {
                quitf(
                    0,
                    "Too few ways to get from %d to %d, should be %d found %d",
                    i, 
                    j, 
                    p[i][j], 
                    actual_ways[i][j]
                );
            }
        }
    }

}

}

const std::string output_secret = "1f0934cc-cf56-429c-b010-8533ab3ded9e";

int main() {
  ios::sync_with_stdio(false);

  fin.open("input");
  fans.open("answer");
  fp.open("score.txt");

  string secret; fin >> secret; cout << secret << endl;
  fin >> n;
  cout << n << endl;
  p.resize(n, vector<int>(n));
  for (int i = 0; i < n; ++i) {
    for (int j = 0; j < n; ++j) {
      int x;
      fin >> p[i][j];
      cout << p[i][j] << ' ';
    }
    cout << endl;
  }

  string result;
  getline(cin, result);
  if (result != output_secret) {
    cerr << "secret mismatch" << endl;
    fp << 0 << endl;
    return 0;
  }
  getline(cin, result);
  if (result != "OK") {
    cerr << result << endl;
    fp << 0 << endl;
    return 0;
  }

  long long jans, pans;
  cin >> pans;
  fans >> result; fans >> result;
  fans >> jans;
  if (pans == jans) {
    if (pans) {
      b.resize(n, vector<int>(n));
      b_adj.resize(n);
      for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
          cin >> b[i][j];
          if (b[i][j]) {
            b_adj[i].push_back(j);
          }
        }
      }

      Checker::check();

      cerr << "OK build correctly" << endl;
    } else
      cerr << "OK no answer" << endl;
    fp << 100 << endl;
  } else {
    cerr << "WA jury found answer but participant didn't" << endl;
    fp << 0 << endl;
  }

  return 0;
}
