#include <cstdio>
#include <string>
#include <cassert>

void writeScore(int scr) {
	FILE* score = fopen("score.txt", "w");
	fprintf(score, "%d\n", scr);
	fclose(score);
	return ;
}

int main() {
	FILE* fin = fopen("input", "r");
	char in_secret[1000];

	fscanf(fin, "%s", in_secret);
	puts(in_secret);

	int n, k, q;
	fscanf(fin, "%d%d%d", &n, &k, &q);
	printf("%d %d %d\n", n, k, q);

	for (int i = 0; i < n; i++) {
		int value;
		fscanf(fin, "%d", &value);
		printf("%d%c", value, i == n - 1 ? '\n' : ' ');
	}

	for (int i = 0; i < q; i++) {
		int x, y;
		fscanf(fin, "%d%d", &x, &y);
		printf("%d %d\n", x, y);
	}

	fclose(fin);
	fflush(stdout);

	FILE* fans = fopen("answer", "r");
	assert(fans != NULL);
	char out_secret[1000], output_secret[1000];

	scanf("%s", out_secret);
	fscanf(fans, "%s", output_secret);
	if (std::string(out_secret) != std::string(output_secret)) {
		writeScore(0);
		fprintf(stderr, "secret mismatch");
		fclose(fans);
		return 0;
	}

	char verdict[1000], redundant_verdict[1000];
	fscanf(fans, "%s", redundant_verdict);
	scanf("%s", verdict);

	if (std::string(verdict) == "SV") {
		writeScore(0);
		fprintf(stderr, "Security violation in grader");
		fclose(fans);
		return 0;
	}

	for (int i = 0; i < q; i++) {
		int pans, jans;

		if (scanf("%d", &pans) != 1) {
			writeScore(-1);
			fprintf(stderr, "Something wrong on query %d: should read an answer.", i + 1);
			fclose(fans);
			return 0;
		}

		fscanf(fans, "%d", &jans);

		if (pans != jans) {
			writeScore(0);
			fprintf(stderr, "Query %d: you output %d, but expect %d", i + 1, pans, jans);
			fclose(fans);
			return 0;
		}
	}

	writeScore(100);
	fprintf(stderr, "OK");
	fclose(fans);

	return 0;
}
