#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
const int nmax=50000;
const int mmax=100000;

struct edge{
   int first;
   int second;
   bool incl=false;
};

vector<edge> jedges;
vector<int> path;

int n,m;
int k;

bool compare(edge a, edge b){
  return((a.first < b.first) || ((a.first==b.first) && (a.second < b.second)));
}

int finded(edge x){
  int ans;
  int L, R, M;

  ans=0;

  L=0; R=jedges.size()-1;
  while (L<=R){
    M=(L+R)/2;
    if (compare(x, jedges[M]))
        R=M-1;
    else
        L=M+1;
  }

  if ((jedges[R].first != x.first) || (jedges[R].second != x.second))
      ans = 1;
  else
      if (jedges[R].incl)
          ans = 2;
      else
          jedges[R].incl = true;
  return ans;
}

void verify(bool x, string s = "Wrong answer") {
	if (x == false)
        wrong_answer(s.c_str());
}
void OK() {
    judge_message("Ok, right answer\n");
	accept();
}

void halfWrong() {
  judge_message("Suyt AC\n");
  accept_with_score(70.);
}

void check(istream &fin, istream &fans, istream &fout, feedback_function waf) {
    long long Kien, LongVu;
   	fout >> Kien;
   	fans >> LongVu;
    if (Kien != LongVu)
        waf("Chuc cac ban lop 12 thi tot nghiep vui ve\n");

    bool ok = 1;
    int n, c;
    fin >> n >> c;

    map<pair<int, int>, int> edges;
    vector<long long> p(n + 1);

    for(int i = 1; i <= n; ++ i) fin >> p[i];

    for(int i = 1; i < n; ++ i) {
      int u, v, w; fin >> u >> v >> w;
      if(u > v) swap(u, v);
      edges[make_pair(u, v)] = w;
    }

    long long Ans = 0;
    int steps;
    for(fout >> steps; steps-- > 0;) {
      int u, v; fout >> u >> v;
      if(u < 1 || u > n) halfWrong();
      if(v < 1 || v > n) halfWrong();

      long long w; fout >> w;
      if(edges.count(make_pair(min(u, v), max(u, v))) == 0) halfWrong();
      if(p[u] < w) halfWrong();
      if(w < 0) halfWrong();

      p[u] -= w, p[v] += w;
      Ans += 1ll * ((w + c - 1) / c) * edges[make_pair(min(u, v), max(u, v))];
    }
    if(Ans != LongVu) halfWrong();

    long long mn = 1e18, mx = 0;
    for(int i = 1; i <= n; ++ i) mn = min(mn, p[i]), mx = max(mx, p[i]);
    if(mx - mn > 1) halfWrong();

    long long pSum = accumulate(p.begin(), p.end(), 0ll);
    if(pSum % n == 0 && mx > mn) halfWrong();

    char thuykieu;
    if(fout >> thuykieu) {
      judge_message("Suyt AC\n");
      accept_with_score(70.);
    }
    OK();
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
}
