#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void verify(bool x, string s = "Wrong answer") {
	if (x == false)
        wrong_answer(s.c_str());
}
void OK() {
    judge_message("Ok, right answer\n");
    accept();
}
#define sp ' '
#define endl '\n'
#define fi first
#define se second
#define mp make_pair
#define ll long long
#define N 100005
struct data {
	ll ans = -1;
	vector<int> order;
} con, ans;

int n;
vector<int> a;

void check(istream &fin, istream &fans, istream &fout, feedback_function waf) {
    fin >> n;
	for (int i = 0; i < n; i++) {
		int t;
		fin >> t;
		a.push_back(t);
	}
	fans >> ans.ans;
	if (!(fout >> con.ans))
        waf("Wrong answer (Wrong format)");
	for (int i = 0; i < n; i++) {
		int t = -1e9;
		fout >> t;
		/*
        if (!(fout >> t))
            waf("Wrong answer (Wrong format)");
        */
		con.order.push_back(t);
	}
	int cnt = 0;
	if (ans.ans == con.ans) cnt++;
	for (int i = 0; i < n; i++) {
		ans.ans -= abs(con.order[i] - a[i]);
	}
	if (ans.ans == 0) {
		vector<int> x = con.order;
		sort(x.begin(), x.end());
		if (x == con.order) cnt++;
	}
	if (cnt == 0)
        waf("Wrong answer!");
	if (cnt == 1)
        accept_with_score(50.);

	OK();
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
}
