import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
_as = ans.readline().strip()

ouf = open("user_out", "r")
_os = ouf.readline().strip()

if _os == "NO":
    if _as.endswith("OK"):
        wrong(u"Đáp án: YES, bạn: NO")
    else:
        ok(u"Không có cách tô màu thỏa mãn")
else:
    color = ouf.readline().strip()
    for x in color:
        if x not in 'RGB':
            wrong(u'Màu sử dụng không đúng')

    inf = open("input", 'r')
    n, m = [int(x) for x in inf.readline().strip().split()]
    if len(color) != n:
        wrong(u"Chuỗi mô tả màu chưa đúng")
    color = ' ' + color
    for _ in range(m):
        u, v = [int(x) for x in inf.readline().strip().split()]
        if color[u] == color[v]:
            wrong(u"Cách tô màu chưa đúng")

ok(u"Ơ mây zing, gút chúp em")