import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

inf = open("input", "r")
n, k = [int(x) for x in inf.readline().split()]
a = [int(x) for x in inf.readline().split()]

ouf = open("user_out", "r")
b = [int(x) for x in ouf.readline().split()]

assert(len(b) > 0)

if b[0] == -1:
	assert(len(b) == 1)
	ans = open('answer', 'r')
	_ans = int(ans.readline())
	if (b[0] != _ans):
		wrong(u"Rất tiếc, phương án chia không thỏa đáng")
	else:
		ok(u"Ở mây zing, gút chóp em")

if len(b) != n:
	wrong(u'Dữ liệu ra không đúng')

sum = [0 for _ in range(k)]
for i, x in enumerate(b):
	if x < 1 or x > k:
		wrong(u'Chia nhóm không đúng');

	sum[x - 1] += a[i]

x = sum[0]
OK = True
for y in sum:
	if y != x:
		OK = False
		break

if OK:
	ok(u"Ơ mây zing gút chóp em")
else:
	wrong(u"Rất tiếc, phương án chia không thỏa đáng")