from functools import wraps
import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
a_K = int(ans.readline().strip())
ouf = open("user_out", "r")
o_K = int(ouf.readline().strip())

if (o_K < a_K):
    wrong(f"Đáp án: {a_K}, Bạn: {o_K}")
p = [int(x) for x in ouf.readline().strip().split()]

inf = open("input", 'r')
n = int(inf.readline().strip())
a = [int(x) for x in inf.readline().strip().split()]

for x in p:
    if x < 1 or x > n:
        wrong(f"Dãy chỉ số không đúng")

for i in range(1, o_K):
    if p[i] <= p[i - 1]:
        wrong(f"Dãy chỉ số không đúng")

if p[-1] != n:
    wrong(f"Dãy chỉ số không đúng")

seg = 0
for i in range(p[0]):
    seg += a[i]

for i in range(1, o_K):
    s = 0
    for j in range(p[i - 1], p[i]):
        s += a[j]
    if s != seg:
        wrong(f"Đoạn thứ {i + 1} không đúng")

ok(u"Ơ mây zing, gút chóp em")