#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Dữ liệu ra không đúng định dạng.\n");
    judge_message("OK. Phương án xây dựng hành lang được chấp nhận!\n");
}

#define MAXLEN 1000000
#define maxn 50001
#define maxm 200001

typedef pair<int,int> II;

int n, m, deg[maxn];
vector<int> g[maxn];
II e[maxm];

int s[maxn], st[maxn], cl[maxn], cur[maxn], pe[maxn], pd[maxn];
int slt=0, id=0, num[maxn], low[maxn], lt[maxn];
void dfs(int xp) {
    int sn=0,stn=0;
    s[++sn]=xp, cl[xp]=1, pe[xp]=pd[xp]=0;
    st[++stn]=xp;
    num[xp]=low[xp]=++id;
    while (sn) {
        int u=s[sn];
        if (cur[u]<deg[u]) {
            int i=g[u][cur[u]++];
            if (i!=pe[u]) {
                int v=(e[i].first==u) ? e[i].second : e[i].first;
                if (cl[v]==0) {
                    s[++sn]=v, cl[v]=1, pe[v]=i, pd[v]=u;
                    st[++stn]=v;
                    num[v]=low[v]=++id;
                } else low[u]=min(low[u],num[v]);
            }
        } else {
            int w=pd[u];
            if (w) low[w]=min(low[w],low[u]);
            if (num[u]==low[u]) {
                ++slt;
                int v;
                do {
                    v=st[stn--];
                    lt[v]=slt;
                    cl[v]=2;
                } while (u!=v);
            }
            --sn;
        }
    }
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    inf >> n >> m;
    for(int i=1;i<=m;i++) {
        int u, v;
        inf >> u >> v;
        e[i]=make_pair(u,v);
        g[u].push_back(i); deg[u]++;
        g[v].push_back(i); deg[v]++;
    }
    int kqa, kqo;
    ans >> kqa;
    if (!(ouf >> kqo))
        waf("Sai. Không đọc được số lượng hàn lang cần xây thêm!\n");

    if (kqa!=kqo)
        waf("Sai (DA=%d, HS=%d) !\n");

    for(int i=1;i<=kqo;i++) {
        int u, v;
        if (!(ouf >> u >> v))
            waf("Sai. Không đọc được hành lang thứ %d\n", i);

        e[++m]=make_pair(u,v);
        g[u].push_back(m); deg[u]++;
        g[v].push_back(m); deg[v]++;
    }

    for(int i=1;i<=n;i++) cl[i]=cur[i]=0;
    id=0;
    for(int i=1;i<=n;i++) if (cl[i]==0) dfs(i);

    if (slt>1)
        waf("Sai. Phương án xây hành lang không hợp lý!\n");

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
