#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Ban da dien dung!\n");
}

#define nmax 15
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int n, x[nmax], y[nmax], v;
    typedef vector<int> vti;
    typedef vector<vti> vtv;
    bool c[1001];
    vtv row(nmax, vti(0)), col(nmax, vti(0));
    inf >> n;
    for (int i = 1; i <= n; i++)
        inf >> x[i];
    for (int i = 1; i <= n; i++)
        inf >> y[i];

    memset(c, 0, sizeof c);
    for (int i = 1; i <= n; i++)
        for (int j = 1; j <= n; j++) {
            if (!(ouf >> v))
                waf("Sai. Du lieu ra khong dung dinh dang!\n");
            if (v < 0 || v > 1000)
                waf("Sai. Gia tri %d sai!\n", v);
            if (v) {
                if (c[v])
                    waf("Sai. So %d da dung roi!\n", v);
                c[v] = 1;
                row[i].push_back(v);
                col[j].push_back(v);
            }
        }
    for (int i = 1; i <= n; i++) {
        if (row[i].size() != 2)
            waf("Sai. Dong %d dien khong dung 2 so!\n", i);
        if (col[i].size() != 2)
            waf("Sai. Cot %d dien khong dung 2 so!\n", i);
        if (row[i][0] * row[i][1] != y[i])
            waf("Sai. Tich hai so tren dong %d khong dung!\n", i);
        if (col[i][0] * col[i][1] != x[i])
            waf("Sai. Tich hai so tren cot %d khong dung!\n", i);
    }

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
