#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Duong di duoc chap nhan!\n");
}

#define nmax 101125
int r[nmax], ith[nmax];

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int rlen = 1, rith = 1;
    for (int i = 0; i < nmax - 635; i+= rlen, rlen += 2, rith++)
        for (int j = 1; j <= rlen; j++) {
            r[i + j] = rith;
            if ((i + j - 2 >= 1) && r[i + j] == r[i + j - 2])
                ith[i + j] = ith[i + j - 2] + 1;
            else
                ith[i + j] = 1;
        }
    int s, t, res, os, u, v;
    inf >> s >> t;
    ans >> res;
    if (!(ouf >> os))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    if (os > res)
        waf("Sai. So buoc di chuyen khong toi uu!\n");

    if (!(ouf >> u))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (u != s)
        waf("Sai. Duong di phai xuat phat tu %d!\n", s);

    for (int i = 0; i < os; i++) {
        if (!(ouf >> v))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (v <= 0 || v >= nmax)
            waf("Sai. Dinh %d tren duong di khong dung!\n", v);

        if (r[u] == r[v]) {
            if (abs(u - v) != 1)
                waf("Sai. Buoc di chuyen tu o %d sang o %d khong dung!\n", u, v);
        }
        else {
            if (abs(r[u] - r[v]) != 1)
                waf("Sai. Buoc di chuyen tu o %d sang o %d khong dung!\n", u, v);
            if ((u & 1) != (v & 1))
                waf("Sai. Buoc di chuyen tu o %d sang o %d khong dung!\n", u, v);
            if (u > v) {
                if ((u & 1) == (r[u] & 1))
                    waf("Sai. Buoc di chuyen tu o %d sang o %d khong dung!\n", u, v);
            }
            else {
                if ((u & 1) != (r[u] & 1))
                    waf("Sai. Buoc di chuyen tu o %d sang o %d khong dung!\n", u, v);
            }
            if (ith[u] != ith[v])
                waf("Sai. Buoc di chuyen tu o %d sang o %d khong dung!\n", u, v);
        }
        u = v;
    }
    if (u != t)
        waf("Sai. Duong di phai ket thuc tai %d!\n", t);
    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
