#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 100001
#define oo 1000000001
struct adj {
    int u, h, d;
};
typedef vector<adj> ke;
typedef long long ll;
ke dsk[nmax];
int n, m, s, t, H, k;
ll D, res = 0;
vector<int> p;

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Duong di co chieu cao khong nho hon %d va co chieu dai %lld!\n", H, res);
}
int check(int u, int v) {
    int res = oo;
    for (adj x : dsk[u])
        if (x.u == v && x.h >= H)
            res = min(res, x.d);
    return res;
}
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    ans >> H >> D;

    if (!(ouf >> k))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (k == 0)
        waf("Sai. Do thi luon co duong di tu %d den %d!\n", s, t);

    inf >> n >> m >> s >> t;

    for (int x, i = 0; i < k; i++) {
        if (!(ouf >> x))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (x < 1 || x > n)
            waf("Sai. Dinh %d tren duong di khong dung!\n", x);
        p.push_back(x);
    }

    for (int u, v, h, d, i = 0; i < m; i++) {
        inf >> u >> v >> h >> d;
        dsk[u].push_back({v, h, d});
        dsk[v].push_back({u, h, d});
    }

    if (p.front() != s)
        waf("Sai. Duong di khong xuat phat tu %d!\n", s);

    if (p.back() != t)
        waf("Sai. Duong di khong ket thuc tai %d!\n", t);

    for (int i = 1; i < p.size(); i++)
        res += check(p[i - 1], p[i]);

    if (res > D)
        waf("Sai. Duong di tim duoc chua toi uu!\n");

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
