#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    string a, o;
    int n, m, k;
    ans >> a;
    a = (a == "Yes" ? "YES" : "NO");
    if (!(ouf >> o))
        waf("Du lieu ra khong dung dinh dang.");
    if (o != a)
        waf("Ket qua sai. Dap an: %s, Tra loi: %s", a.c_str(), o.c_str());
    if (a == "NO") {
        string S;
        if (ouf >> S)
            waf("Du lieu ra khong dung dinh dang.");
        judge_message("OK. No solution!\n");
        return 1;
    }

    inf >> n >> m >> k;
    int x;
    bool dd[2001];
    memset(dd, 0, sizeof(dd));
    while (ouf >> x){
        if (x < 1 || x > n)
            waf("Dat thiet bi o dinh %d khong dung.", x);
        dd[x] = 1;
        k--;
    }
    if (k < 0)
        waf("Dung qua so luong cho phep!\n");

    for (int i = 1; i <= m; i++){
        int u, v;
        inf >> u >> v;
        if (dd[u] || dd[v]) continue;
        waf("Canh %d %d khong co thiet bị kiem tra!\n", u, v);
    }

    judge_message("OK, tra loi dung!\n");
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
