#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
bool check(string &a, string &b, int w) {
    int n = a.length(), m = b.length();
    int f[1501];
    memset(f, 0, sizeof f);
    f[0] = (a[0] == b[0]);
    for (int i = 1; i < n; i++) {
        for (int j = i - 1; j >= 0 && i - j <= w; j--)
            if (a[i] == b[f[j]])
                f[i] = max(f[i], f[j] + 1);
    }
    /*
    for (int i = 0; i < n; i++)
        cout << f[i] << ' ';
    cout << "\n";
    */
    for (int i = n - 1; i >= 0 && n - i <= w + 1; i--)
        if (f[i] == m) return 1;
    return 0;
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int w;
    string s, t, a, o;
    getline(ans, a);
    getline(ouf, o);
    while (a.back() == ' ' || a.back() == '\n' || a.back() == '\r' || a.back() == '\t')
        a.pop_back();
    judge_message("ans (%d): %s\n", a.length(), a.c_str());
    judge_message("out (%d): %s\n", o.length(), o.c_str());

    if (a == o) {
        judge_message("Dung.");
        return 1;
    }
    if (a == "No solution")
        waf("Sai.");
    if (a.length() != o.length())
        waf("Sai.");

    inf >> w >> s >> t;
    if (!check(s, o, w))
        waf("Sai.");

    if (!check(t, o, w))
        waf("Sai.");

    judge_message("Dung.");
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
