#include <cmath>
#include <vector>
#include <algorithm>
#include <cstring>

#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <sys/stat.h>
#include <cassert>
#include <cstdarg>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <sstream>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    /*
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
    */
}
using namespace std;
#define nmax 51
double checkAll(istream &inf, istream &ans, istream &ouf, feedback_function err, feedback_function af) {
    int T, match = 0;
    inf >> T;
    for (int _i = 1; _i <= T; _i++) {
        int a[nmax][nmax], m, n, p, u, v, s, t;
        inf >> m >> n;
        for (int i = 1; i <= m; i++)
            for (int j = 1; j <= n; j++)
                inf >> a[i][j];
        if (!(ouf >> p))
            break;
        if (p < 0)
            af("Number of swap < 0");

        int max1 = 0, max2 = 1;
        int d[nmax];
        memset(d, 0, sizeof d);
        for (int i = 1; i <= m; i++)
            for (int j = 1; j <= n; j++)
                d[a[i][j]]++;
        for (int i = 1; i <= n; i++)
            if (d[i] % m != 0) {
                max2 = 2;
                break;
            }
        while (p--) {
            if (!(ouf >> u >> v >> s >> t))
                break;
            if (u > 0 && u <= m && v > 0 && v <= n && s > 0 && s <= m && t > 0 && t <= n)
                swap(a[u][v], a[s][t]);
            else
                af("Can\'t swap (%d, %d) vs (%d, %d)", u, v, s, t);
        }

        for (int i = 1; i <= n; i++) {
            int c[nmax], cnt = 0;
            memset(c, 0, sizeof c);
            for (int j = 1; j <= m; j++) {
                if (!c[a[j][i]]) cnt++;
                c[a[j][i]]++;
            }
            max1 = max(max1, cnt);
        }
        if (max1 <= max2) match++;
    }
    judge_message("You are correct %d/%d.", match, T);
    return 100. * match/T;
}

#endif

int main(void) {
    init_io();
    //Note that this checker do not use ans file
    double score = checkAll(judge_in, judge_ans, user_out, judge_error, wrong_answer);
    accept_with_score(score);
}
